//---------------------------------------------------------
#ifndef USBDetectH
#define USBDetectH
//---------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
#include <objbase.h>
#include <Dbt.h>

static GUID GUID_DEVINTERFACE_USB_DEVICE =
{0xA5DCBF10, 0x6530, 0x11D2, {0x90, 0x1F, 0x00, 0xC0,
                              0x4F, 0xB9, 0x51, 0xED}};

//---------------------------------------------------------
class PACKAGE TUSBDetect : public TComponent {
  private:
     HWND FWindowHandle;
     TNotifyEvent FUSBAttach;
     TNotifyEvent FUSBDetach;
     void __fastcall WindowProc(TMessage &msg);
     bool __fastcall USBDeviceNotify();
  protected:
     void __fastcall deviceAttachDetach(TMessage &msg);
  public:
     __fastcall TUSBDetect(TComponent* Owner);
     __fastcall virtual ~TUSBDetect();
  __published:
     __property TNotifyEvent USBAttach = {read=FUSBAttach,
                                          write=FUSBAttach};
     __property TNotifyEvent USBDetach = {read=FUSBDetach,
                                          write=FUSBDetach};
};
//---------------------------------------------------------
#endif
//---------------------------------------------------------
